require("SandboxVars")
table.insert(SandboxVars, {
	options = {
		{ name = "bombVehicleInteract", title = "Use Bombs Set Off Car Alarms", default = true },
	}
})

local function BombVehicleInteractions()
if SandboxVars.GamestaVehicleZones.bombVehicleInteract ~= true then return end

local function scanVehiclesInRadius(x, y, z, radius, setBombAction)
	if not (x and y and z) then return end
	local cell = getCell()
	local square = cell:getOrCreateGridSquare(x, y, z)
	local seen = {}
	local r2 = radius * radius
	for dx = -radius, radius do
		for dy = -radius, radius do
			local hitPoint = (dx * dx + dy * dy)
			if hitPoint <= r2 then
				local sq0 = cell:getGridSquare(x + dx, y + dy, z)
				if sq0 then
					local vehicles = sq0:getVehicleContainer()
					if vehicles ~= nil and not seen[vehicles] then
						seen[vehicles] = true

						if setBombAction then
						--	local rand = newrandom()
						--	local radiusDamage = setBombAction[1]	--too inconsistent and needs more work
						--	local radiusFling = setBombAction[2]	--buggy with too much force and doesn't work outside of debug mode
						--	local radiusJump = setBombAction[3]		--doesn't work outside of debug mode
							local radiusAlarm = setBombAction[4]
							if radiusAlarm and hitPoint <= radiusAlarm^2 then
								if not vehicles:isBurnt() and not vehicles:isSmashed() and not string.contains(string.lower(vehicles:getScriptName()), "trailer") then
									if vehicles:isAlarmed() then
										vehicles:triggerAlarm()
									end
								end
							end
						end

					end
				end
			end
		end
	end
end

local function explodeVehicles(throwable, square)
	local bombType = throwable:getExplosionSound()
	local radius
	local damageType
	if bombType == "PipeBombExplode" then
		radius = 20
		damageType = {2, 5, 10, 20}
	elseif bombType == "AerosolBombExplode" then
		radius = 12
		damageType = {2, 3, 6, 12}
	elseif bombType == "MolotovCocktailExplode" then
		radius = 3
		damageType = {3, nil, nil, 2}
	elseif bombType == "FlameTrapExplode" then
		radius = 5
		damageType = {5, nil, nil, 2}
	else
		return
	end
	scanVehiclesInRadius(square:getX(), square:getY(), square:getZ(), radius, damageType)
end
Events.OnThrowableExplode.Add(explodeVehicles)

end
Events.OnInitGlobalModData.Add(BombVehicleInteractions)
